<?php
/**
*
* @package Cdm
* @copyright (c) 2015 Lionel Retif
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace cartedesmembres\cdm\migrations;

class m2_initial_data extends \phpbb\db\migration\migration
{
	public function effectively_installed()
	{
		return isset($this->config['cdm_version']) && version_compare($this->config['cdm_version'], '0.0.1', '>=');
	}

	static public function depends_on()
	{
		return array('\cartedesmembres\cdm\migrations\m1_initial_schema');
	}

	public function update_data()
	{
		return array(
			array('config.add', array('cdm_version', '0.0.2')),
			array('config.add', array('cdm_ID', '0')),
			array('config.add', array('cdm_CODE', 'code_secret')),
			array('config.add', array('cdm_URL', 'http://www.carte-des-membres.com/')),
			array('config.add', array('cdm_NOM', 'nom_de_votre_carte')),
			array('module.add', array('acp','ACP_CAT_DOT_MODS','ACP_CDM_TITLE')),
			array('module.add', array(
                'acp',
                'ACP_CDM_TITLE',
                array(
                    'module_basename' => '\cartedesmembres\cdm\acp\cdm_module',
                    'modes' => array('settings'),
                ),
            )),
		);
	}
}
