<?php
/**
*
* @package Cdm
* @copyright (c) 2015 Lionel Retif
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace cartedesmembres\cdm\migrations;

class m1_initial_schema extends \phpbb\db\migration\migration
{
	public function effectively_installed()
	{
		return $this->db_tools->sql_column_exists($this->table_prefix . 'users', 'user_cdm');
	}

	static public function depends_on()
	{
		return array('\phpbb\db\migration\data\v31x\v314');
	}

	public function update_schema()
	{
		return array(
			'add_columns'	=> array(
				$this->table_prefix . 'users'	=> array(
					'user_cdm'	=> array('UINT', 0),
				),
			),
		);
	}

	public function revert_schema()
	{
		return array(
			'drop_columns' => array(
				$this->table_prefix . 'users'	=> array(
					'user_cdm',
				),
			),
		);
	}
}
