<?php
/**
*
* cdm extension for the phpBB Forum Software package.
*
* @copyright (c) 2015 Lionel Retif
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace cartedesmembres\cdm\event;

/**
* @ignore
*/
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class listener implements EventSubscriberInterface
{
	/**
	* define our constants
	**/
	const CDM_YES = 1;
	const CDM_NO = 0;

	/** @var \phpbb\request\request */
	protected $request;

	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\user */
	protected $user;

	/** @var string phpBB root path */
	protected $phpbb_root_path;

	/** @var string phpEx */
	protected $php_ext;

	/**
	* the path to the images directory
	*
	*@var string
	*/
	protected $cdm_path;

	public function __construct(
	  \phpbb\config\config $config,
		\phpbb\request\request $request,
		\phpbb\template\template $template,
		\phpbb\user $user,
		$phpbb_root_path,
		$php_ext,
		$cdm_path)
	{
    $this->config = $config;
		$this->request = $request;
		$this->template = $template;
		$this->user = $user;
		$this->root_path = $phpbb_root_path;
		$this->php_ext = $php_ext;
		$this->images_path = $cdm_path;
	}

	/**
	* Assign functions defined in this class to event listeners in the core
	*
	* @return array
	* @static
	* @access public
	*/
	static public function getSubscribedEvents()
	{
		return array(
			'core.page_header'            => 'add_page_header_link',
		);
	}

   public function add_page_header_link($event)   {
      // language file here
      $this->user->add_lang_ext('cartedesmembres/cdm', 'cdm');

      $this->template->assign_vars(array(
         'CDM_URL'   => $this->user->lang['CDM_URL'].'/'.$this->user->data['user_lang'].'/'.$this->config['cdm_NOM'].'/',
      ));
   }
}
