<?php
/**
*
* @package cdm Extension
* @copyright (c) 2013 Lionel Retif
* @license http://opensource.org/licenses/gpl-2.0.php GNU General Public License v2
*
*/

namespace cartedesmembres\cdm\controller;

class cdm
{
   /**
   * Constructor
   * NOTE: The parameters of this method must match in order and type with
   * the dependencies defined in the services.yml file for this service.
   *
   * @param \phpbb\config   $config      Config object
   * @param \phpbb\template   $template   Template object
   * @param \phpbb\user   $user      User object
   * @param \phpbb\controller\helper      $helper            Controller helper object
   * @param string         $root_path   phpBB root path
   * @param string         $php_ext   phpEx
   */
   public function __construct(\phpbb\config\config $config, \phpbb\template\template $template, \phpbb\user $user, \phpbb\controller\helper $helper, $root_path, $php_ext)
   {
      $this->config = $config;
      $this->template = $template;
      $this->user = $user;
      $this->helper = $helper;
      $this->root_path = $root_path;
      $this->php_ext = $php_ext;
      $this->user->add_lang_ext('cartedesmembres/cdm', 'cdm');
   }

   /**
   * Base controller to be accessed with the URL /newspage/{page}
   * (where {page} is the placeholder for a value)
   *
   * @param int   $page   Page number taken from the URL
   * @return Symfony\Component\HttpFoundation\Response A Symfony Response object
   */
   public function cdm($page = 1)
   {
      if ($this->user->data['user_id'] != ANONYMOUS){
        if ($this->config['cdm_ID']=='0' || strlen($this->config['cdm_CODE'])<4 || strlen($this->config['cdm_NOM'])<4){
           // echo 'assign';
            $this->template->assign_vars(array(
            'cdm_INFO'=>$this->user->lang['CDM_NO_CONFIG'],
            ));
            
            return $this->helper->render('cdm_body.html');
        }
        
      $t=time();
      $redirect=$this->config['cdm_URL'].'/add?c='.md5($this->config['cdm_ID'].'_'.$this->user->data['user_id'].'_'.$this->user->data['username'].'_'.$t.'_'.$this->config['cdm_CODE']).'&ids='.$this->config['cdm_ID'].'&t='.$t.'&idp='.$this->user->data['user_id'].'&p='.urlencode($this->user->data['username']);
      $redirectjs='<script>location.href=\''.$redirect.'\';</script><a href="'.$redirect.'">redirect</a>';
        
      $this->template->assign_vars(array(
      'cdm.USERNAME'=>$this->user->data['username'],
      'cdm.USER_ID'=>$this->user->data['user_id'],
      'cdm.CDM_ID'=>$this->config['cdm_ID'],
      'cdm.CDM_CODE'=>$this->config['cdm_CODE'],
      'cdm.CDM_URL'=>$this->config['cdm_URL'],
      'cdm_INFO'=>$redirectjs,
      ));
      
      //redirect($redirect); //non possible
      //exit;
      }
      else{
        //trigger_error('SORRY_AUTH_READ');
        login_box('', $this->user->lang['CDM_HAVE_TO_LOGIN']);
      }

      /*
      * The render method takes up to three other arguments
      * @param   string      Name of the template file to display
      *                  Template files are searched for two places:
      *                  - phpBB/styles/<style_name>/template/
      *                  - phpBB/ext/<all_active_extensions>/styles/<style_name>/template/
      * @param   string      Page title
      * @param   int         Status code of the page (200 - OK [ default ], 403 - Unauthorized, 404 - Page not found, etc.)
      */
      return $this->helper->render('cdm_body.html');
   }
}