<?php
/**
*
* dm extension for the phpBB Forum Software package.
*
* @copyright (c) 2015 Lionel Retif <http://www.carte-des-membres.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

namespace cartedesmembres\cdm\acp;

class cdm_module
{
    public $u_action;
    public $tpl_name;
    public $page_title;

    public function main($id, $mode)
    {
        global $user, $template, $request, $config;

        $user->add_lang_ext('cartedesmembres/cdm', 'cdm');
        
        $user->add_lang('acp/common');
        
        $this->tpl_name = 'acp_cdm_body';
        
        $this->page_title = $user->lang('ACP_CDM_TITLE');
        
        add_form_key('cartedesmembres/cdm');
      
        if ($request->is_set_post('submit'))
        {
            if (!check_form_key('cartedesmembres/cdm'))
            {
                $user->add_lang('acp/common');
                trigger_error('FORM_INVALID');
            }

            $config->set('cdm_ID', $request->variable('cdm_ID', 0));
            $config->set('cdm_CODE', $request->variable('cdm_CODE', ''));
            $config->set('cdm_NOM', $request->variable('cdm_NOM', ''));

            trigger_error($user->lang('ACP_CDM_SETTING_SAVED') . adm_back_link($this->u_action));
        }

        $template->assign_vars(array(
            'U_ACTION'           => $this->u_action,
            'cdm_CODE'           => $config['cdm_CODE'],
            'cdm_ID'             => $config['cdm_ID'],
            'cdm_NOM'            => $config['cdm_NOM'],
        ));
    }
}